//
//  NSView+BIAdditions.h
//  BIViews
//
//  Created by Alykhan Jetha on 05/05/08.
//  Copyright 1999-2006 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class BIPrimeWindowView;
@class BIPrimeTabView;
@class BIProjectSlipsView;
@class BIProjectsView;
@class BIAccountView;
@class BIDatabaseObjectContext;
@class BIDocument;
@class BIQueryHandler;
@class BISplitView;
@class BISearchResultsView;
@class BIClientInfoView;
@class BIUser;

extern void MCDrawHorizontalThreePartImageInRect(NSImage *left, NSImage *fill, NSImage *right, NSCompositingOperation op, NSRect rect);


@interface NSView (BIAdditions)

- (void)biDrawOnePixelLineAtPosition:(float)pos inRect:(NSRect)aRect usingColor:(NSColor *)aColor horizontal:(BOOL)isHorizontal;

- (void)biDrawHorizontalRepeatImage:(NSImage *)img operation:(NSCompositingOperation)op inRect:(NSRect)rect pinToTop:(BOOL)top;

// deprecated - AJ
// - (void)biDrawResizeHandleInRect:(NSRect)rect;




- (BIPrimeWindowView *)enclosingPrimeWindowView;
- (BIPrimeTabView *)enclosingPrimeTabView;
- (BIProjectSlipsView *)enclosingProjectSlipsView;
- (BIProjectsView *)enclosingProjectsView;
- (BIAccountView *)enclosingAccountView;
- (BISearchResultsView *)enclosingSearchResultsView;
- (BIClientInfoView *) biEnclosingClientInfoView;

- (BISplitView *)biEnclosingSplitView;

- (BOOL)isWindowFinishedSetup;

// dedicated shortcuts
- (id)biDocument;
- (BIDatabaseObjectContext *)biObjectContext;
- (BIQueryHandler *)biQueryHandler;
- (BIUser *)biCurrentUser;

@end
